/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.ap;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractApro {
    private DoubleMatrix2D ar;
    private int[] exemplars;

    public abstract int getN();

    public abstract DoubleMatrix2D getR();

    public abstract DoubleMatrix2D getA();

    public abstract DoubleMatrix2D getS();

    public synchronized DoubleMatrix2D getAR() {
        if (this.ar != null) {
            return this.ar;
        }
        int n = this.getN();
        DoubleMatrix2D s = this.getS();
        DoubleMatrix2D a = this.getA();
        DoubleMatrix2D r = this.getR();
        this.ar = s instanceof SparseDoubleMatrix2D ? new SparseDoubleMatrix2D(n, n) : new DenseDoubleMatrix2D(n, n);
        IntArrayList is = new IntArrayList();
        IntArrayList ks = new IntArrayList();
        DoubleArrayList vs = new DoubleArrayList();
        s.getNonZeros(is, ks, vs);
        for (int j = 0; j < is.size(); ++j) {
            int i = is.get(j);
            int k = ks.get(j);
            double v = a.getQuick(i, k) + r.getQuick(i, k);
            this.ar.setQuick(i, k, v);
        }
        return this.ar;
    }

    public void clear() {
        this.ar = null;
    }

    public synchronized Set<Integer> getExemplarSet() {
        HashSet<Integer> exes = new HashSet<Integer>();
        int[] exemplars = this.getExemplars();
        for (int i = 0; i < exemplars.length; ++i) {
            exes.add(exemplars[i]);
        }
        return exes;
    }

    public synchronized int[] getExemplars() {
        if (this.exemplars != null) {
            return this.exemplars;
        }
        this.getAR();
        int n = this.getN();
        IntArrayList is = new IntArrayList();
        IntArrayList ks = new IntArrayList();
        DoubleArrayList vs = new DoubleArrayList();
        this.ar.getNonZeros(is, ks, vs);
        this.exemplars = new int[n];
        double[] maxs = new double[n];
        for (int i = 0; i < n; ++i) {
            this.exemplars[i] = -1;
            maxs[i] = Double.NEGATIVE_INFINITY;
        }
        for (int j = 0; j < is.size(); ++j) {
            int i = is.get(j);
            double v = vs.get(j);
            if (!(v > maxs[i])) continue;
            maxs[i] = v;
            this.exemplars[i] = ks.get(j);
        }
        return this.exemplars;
    }

    public synchronized int getExemplar(int node) {
        int[] exemplars = this.getExemplars();
        return exemplars[node];
    }
}

