/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.ap;

import fr.lri.tao.apro.ap.Apro;
import fr.lri.tao.apro.data.DataProvider;
import fr.lri.tao.apro.util.Logger;
import fr.lri.tao.numa.NUMA;
import fr.lri.tao.numa.SysUtils;

public class AproBuilder {
    private int groupCount;
    private boolean useNuma = false;
    private Integer numNodes = null;
    private Integer coresPerNode = null;
    private Integer startNode = null;
    private Double damping;
    private Boolean debug;

    public AproBuilder() {
        this.setNumaOff();
        this.setThreadsAuto();
    }

    public AproBuilder setThreads(int threadCount) {
        this.groupCount = threadCount;
        return this;
    }

    public final AproBuilder setThreadsAuto() {
        this.groupCount = SysUtils.availableProcessors();
        return this;
    }

    public AproBuilder setNuma(Integer numNodes, Integer coresPerNode, Integer startNode) {
        if (!NUMA.isAvailable()) {
            Logger.warn("NUMA not available, ignoring", new Object[0]);
            return this.setNumaOff();
        }
        this.numNodes = numNodes == null ? Integer.valueOf(NUMA.getNumNodes()) : numNodes;
        this.coresPerNode = coresPerNode == null ? Integer.valueOf(NUMA.getCoresPerNode()) : coresPerNode;
        this.startNode = startNode == null ? Integer.valueOf(NUMA.getNode()) : startNode;
        return this;
    }

    public AproBuilder setNumaAuto() {
        if (NUMA.isAvailable()) {
            this.useNuma = true;
            this.numNodes = NUMA.getNumNodes();
            this.coresPerNode = NUMA.getCoresPerNode();
            this.startNode = NUMA.getNode();
            Logger.info("[NUMA] %d nodes, %d coresPerNode", this.numNodes, this.coresPerNode);
        } else {
            this.setNumaOff();
        }
        return this;
    }

    public AproBuilder setNumaOff() {
        this.useNuma = false;
        this.startNode = null;
        this.coresPerNode = null;
        this.numNodes = null;
        return this;
    }

    public AproBuilder setFullAuto() {
        this.setNumaAuto();
        this.groupCount = this.numNodes != null && this.coresPerNode != null ? this.numNodes * this.coresPerNode : SysUtils.availableProcessors();
        return this;
    }

    public AproBuilder setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public AproBuilder setDamping(double dampingFactor) {
        this.damping = dampingFactor;
        return this;
    }

    public Apro build(DataProvider provider) {
        if (provider == null) {
            throw new NullPointerException("Similarity matrix provider required");
        }
        Apro apro = new Apro(provider, this.groupCount, this.useNuma, this.numNodes, this.coresPerNode, this.startNode);
        if (this.debug != null) {
            apro.setDebug(this.debug);
        }
        if (this.damping != null) {
            apro.setDamping(this.damping);
        }
        return apro;
    }

    public String toString() {
        return "AproBuilder{groupCount=" + this.groupCount + ", useNuma=" + this.useNuma + ", numNodes=" + this.numNodes + ", coresPerNode=" + this.coresPerNode + ", startNode=" + this.startNode + '}';
    }
}

