/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.ap;

import fr.lri.tao.apro.ap.Apro;

public class Group {
    final int gid;
    private final Apro apro;
    final int startIndex;
    final int endIndex;
    int n;
    int size;
    int[] lengths;
    int[] t;
    int[][] indices;
    double[] sums;
    double[][] s;
    double[][] a;
    double max1;
    double max2;
    int forK;

    Group(Apro apro, int gid) {
        this.gid = gid;
        this.apro = apro;
        this.startIndex = apro.startIndex(gid);
        this.endIndex = apro.endIndex(gid);
        this.n = apro.getN();
        this.sums = new double[this.n];
        this.size = this.endIndex - this.startIndex;
        this.lengths = new int[this.size];
        this.t = new int[this.size];
        this.indices = new int[this.size][];
        this.s = new double[this.size][];
        this.a = new double[this.size][];
    }

    public boolean containsNode(int nid) {
        return this.startIndex <= this.gid && this.gid < this.endIndex;
    }

    public String toString() {
        return "Group " + this.gid + " [" + this.startIndex + ", " + this.endIndex + ")";
    }

    public int getId() {
        return this.gid;
    }

    private void calcMax(int i) {
        this.max2 = Double.NEGATIVE_INFINITY;
        this.max1 = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < this.lengths[i]; ++j) {
            double t = this.a[i][j] + this.s[i][j];
            if (t > this.max1) {
                this.max2 = this.max1;
                this.max1 = t;
                this.forK = this.indices[i][j];
                continue;
            }
            if (!(t >= this.max2)) continue;
            this.max2 = t;
        }
    }

    private final double max(int k) {
        if (k == this.forK) {
            return this.max2;
        }
        return this.max1;
    }

    int getNumaNode() {
        return this.apro.getNumaNode(this.gid);
    }

    void computeResponsibilities() {
        double damp = this.apro.getDamping();
        for (int i = 0; i < this.size; ++i) {
            int i1 = i + this.startIndex;
            this.calcMax(i);
            for (int j = 0; j < this.lengths[i]; ++j) {
                int k = this.indices[i][j];
                double temp = this.s[i][j] - this.max(k);
                double oldValue = Math.max(0.0, this.apro.r[i1][k]);
                this.apro.r[i1][k] = (1.0 - damp) * temp + damp * this.apro.r[i1][k];
                double newValue = Math.max(0.0, this.apro.r[i1][k]);
                int n = k;
                this.sums[n] = this.sums[n] + (newValue - oldValue);
            }
        }
        this.apro.updateSums(this);
    }

    private double sumR(int i, int k) {
        if (i != k) {
            return this.apro.sumr[k] - Math.max(0.0, this.apro.r[i][k]) - Math.max(0.0, this.apro.r[k][k]);
        }
        return this.apro.sumr[k] - Math.max(0.0, this.apro.r[k][k]);
    }

    private double sumRBasic(int i, int k) {
        double sum = 0.0;
        for (int j = 0; j < this.n; ++j) {
            if (j == i || j == k) continue;
            sum += Math.max(0.0, this.apro.r[j][k]);
        }
        return sum;
    }

    void computeAvailabilities() {
        double damp = this.apro.getDamping();
        for (int i = 0; i < this.size; ++i) {
            int len = this.lengths[i];
            for (int j = 0; j < len; ++j) {
                double temp;
                int k = this.indices[i][j];
                if (i + this.startIndex != k) {
                    double t = this.apro.r[k][k] + this.sumR(i + this.startIndex, k);
                    temp = Math.min(0.0, t);
                } else {
                    temp = this.sumR(k, k);
                }
                this.a[i][j] = (1.0 - damp) * temp + damp * this.a[i][j];
            }
        }
    }
}

