/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.ap;

import fr.lri.tao.apro.ap.Group;
import fr.lri.tao.numa.NUMA;

public class GroupWorker
extends Thread {
    private final Group group;
    private final boolean useNuma;
    private Mode mode;
    private Mode todo;
    private boolean go = false;
    private boolean done = false;
    private boolean busy = false;

    GroupWorker(Group group, boolean useNuma) {
        this.group = group;
        this.mode = null;
        this.useNuma = useNuma;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.useNuma) {
            int node = this.group.getNumaNode();
            NUMA.runOnNode(node);
        }
        while (!this.done) {
            GroupWorker groupWorker = this;
            synchronized (groupWorker) {
                try {
                    while (!this.go && !this.done) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.done) {
                    break;
                }
                this.go = false;
                this.todo = this.mode;
                this.busy = true;
            }
            if (this.todo == Mode.RESPONSIBILITIES) {
                this.group.computeResponsibilities();
            } else if (this.todo == Mode.AVAILABILITIES) {
                this.group.computeAvailabilities();
            }
            groupWorker = this;
            synchronized (groupWorker) {
                this.busy = false;
                this.notify();
            }
        }
    }

    public void responsibilities() {
        this.go(Mode.RESPONSIBILITIES);
    }

    public void availabilities() {
        this.go(Mode.AVAILABILITIES);
    }

    private synchronized void go(Mode mode) {
        this.waitTask();
        this.go = true;
        this.mode = mode;
        this.busy = true;
        this.notify();
    }

    public synchronized void waitTask() {
        try {
            while (this.busy) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void done() {
        this.done = true;
        this.notify();
    }

    public static enum Mode {
        RESPONSIBILITIES,
        AVAILABILITIES;

    }
}

