/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.data;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import fr.lri.tao.apro.data.DataProvider;
import fr.lri.tao.apro.util.Logger;
import fr.lri.tao.apro.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DSVProvider
implements DataProvider {
    private int n;
    private DoubleMatrix2D s;
    private String delimiters = " \t,;";

    public DSVProvider(File preferences, File similarities) throws IOException {
        this.load(similarities, preferences, 1);
    }

    public DSVProvider(File preferences, File similarities, int base) throws IOException {
        this.load(similarities, preferences, base);
    }

    public DSVProvider(File preferences, File similarities, int base, String delimiters) throws IOException {
        this.delimiters = delimiters;
        this.load(similarities, preferences, base);
    }

    private static List<String> getTokens(String line, String delims) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, delims);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    private List<Double> loadPreferences(File preferences) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(preferences));
        ArrayList<Double> prefs = new ArrayList<Double>();
        boolean i = false;
        while ((line = reader.readLine()) != null) {
            prefs.add(Double.parseDouble(line));
        }
        reader.close();
        return prefs;
    }

    private void load(File similarities, File preferences, int base) throws IOException {
        String line;
        List<Double> prefs = this.loadPreferences(preferences);
        this.n = prefs.size();
        this.s = new SparseDoubleMatrix2D(this.n, this.n);
        int c = 0;
        for (Double p : prefs) {
            this.s.set(c, c, p);
            ++c;
        }
        int simCount = 0;
        BufferedReader reader = new BufferedReader(new FileReader(similarities));
        while ((line = reader.readLine()) != null) {
            List<String> tokens = DSVProvider.getTokens(line, this.delimiters);
            int i = Integer.parseInt(tokens.get(0)) - base;
            int j = Integer.parseInt(tokens.get(1)) - base;
            Double v = Double.parseDouble(tokens.get(2));
            this.s.set(i, j, v);
            ++simCount;
        }
        reader.close();
        double full = 100.0 * (double)(simCount + this.n) / (double)(this.n * this.n);
        Logger.info("[Loader] Loaded %d similarities, matrix is %f%% populated", simCount, full);
    }

    @Override
    public DoubleMatrix2D getMatrix() {
        return this.s;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public void addNoise() {
        Utils.addNoise(this.s);
    }
}

