/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.data;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLSingle;
import com.jmatio.types.MLSparse;
import fr.lri.tao.apro.data.DataProvider;
import fr.lri.tao.apro.util.Logger;
import fr.lri.tao.apro.util.Utils;
import java.io.File;
import java.io.IOException;

public class MATLABProvider
implements DataProvider {
    private int n;
    private DoubleMatrix2D matrix;

    public MATLABProvider(File file, String arrayName) throws IOException {
        this(file, arrayName, null);
    }

    public MATLABProvider(File file, String arrayName, String prefValue) throws IOException {
        this.load(file, arrayName, prefValue);
    }

    private void load(File file, String arrayName, String prefValue) throws IOException {
        MLArray prefArray;
        int i;
        MLNumericArray array;
        MatFileReader mfr = new MatFileReader(file);
        MLArray mlArray = mfr.getMLArray(arrayName);
        assert (mlArray.getN() == mlArray.getM());
        this.n = mlArray.getN();
        Logger.info("[MatLoader] Matrix size: " + this.n + " x " + this.n, new Object[0]);
        if (mlArray instanceof MLSparse) {
            array = (MLSparse)mlArray;
            int[][] indices = ((MLSparse)array).getIndices();
            this.matrix = new SparseDoubleMatrix2D(this.n, this.n);
            for (int j = 0; j < indices.length; ++j) {
                int i2 = indices[j][0];
                int k = indices[j][1];
                this.matrix.set(i2, k, (Double)array.get(i2, k));
            }
            Logger.info("[MatLoader] Elements: %d, density: %f%%", indices.length, 100.0 * (double)indices.length / (double)(this.n * this.n));
        } else if (mlArray instanceof MLDouble) {
            array = (MLDouble)mlArray;
            this.matrix = new DenseDoubleMatrix2D(((MLDouble)array).getArray());
        } else if (mlArray instanceof MLSingle) {
            array = (MLSingle)mlArray;
            double[][] a = new double[this.n][this.n];
            for (i = 0; i < a.length; ++i) {
                for (int j = 0; j < a.length; ++j) {
                    a[i][j] = ((Float)array.getReal(i, j)).floatValue();
                }
            }
            this.matrix = new DenseDoubleMatrix2D(a);
        } else {
            throw new IOException("Unknown format, class " + mlArray.getClass().getName());
        }
        if (prefValue != null && (prefArray = mfr.getMLArray(prefValue)) instanceof MLDouble) {
            MLDouble ps = (MLDouble)prefArray;
            if (ps.getM() == 1 && ps.getN() == 1) {
                double pref = (Double)ps.get(0);
                for (int i3 = 0; i3 < this.n; ++i3) {
                    this.matrix.set(i3, i3, pref);
                }
            } else if (ps.getM() == this.n && ps.getN() == 1) {
                for (i = 0; i < this.n; ++i) {
                    this.matrix.set(i, i, (Double)ps.get(i));
                }
            } else {
                throw new IOException("Preference must be a scalar or a vector of size N");
            }
        }
    }

    @Override
    public DoubleMatrix2D getMatrix() {
        return this.matrix;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public void addNoise() {
        Utils.addNoise(this.matrix);
    }
}

