/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.data.points;

import fr.lri.tao.apro.data.points.Point;
import fr.lri.tao.apro.data.points.Points;
import fr.lri.tao.apro.data.points.SimilarityMeasure;
import fr.lri.tao.apro.util.Percentile;

public class EuclideanSimilarityMeasure
implements SimilarityMeasure {
    @Override
    public double[][] getMatrix(Points points) {
        int n = points.size();
        double[][] s = new double[n][n];
        Percentile percentile = new Percentile();
        for (int i = 0; i < n; ++i) {
            Point p1 = points.getByIndex(i);
            for (int j = i + 1; j < n; ++j) {
                Point p2 = points.getByIndex(j);
                double d = this.similarity(p1, p2);
                s[j][i] = d;
                s[i][j] = d;
                percentile.add(s[i][j]);
            }
        }
        double median = percentile.getMedian();
        for (int i = 0; i < n; ++i) {
            s[i][i] = median;
        }
        return s;
    }

    @Override
    public double similarity(Point p1, Point p2) {
        return p1.similarity(p2);
    }
}

