/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.data.points;

import java.util.Collection;

public class Point {
    public final long id;
    public final double[] features;

    public Point(long id, double[] features) {
        this.id = id;
        this.features = features;
    }

    public long getId() {
        return this.id;
    }

    public Point(long id, Collection<Double> features) {
        this.id = id;
        this.features = new double[features.size()];
        int i = 0;
        for (Double d : features) {
            this.features[i++] = d;
        }
    }

    public double[] getFeatures() {
        return this.features;
    }

    public double distance(Point p) {
        double s = 0.0;
        for (int i = 0; i < Math.min(this.features.length, p.features.length); ++i) {
            double d = this.features[i] - p.features[i];
            s += d * d;
        }
        return Math.sqrt(s);
    }

    public double similarity(Point p) {
        double s = 0.0;
        int len = Math.min(this.features.length, p.features.length);
        for (int i = 0; i < len; ++i) {
            double d = this.features[i] - p.features[i];
            s += d * d;
        }
        return -s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Point ").append(this.id).append(" (");
        for (int i = 0; i < this.features.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.features[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        Point p = (Point)o;
        return p.id == this.id;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

