/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.data.points;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import fr.lri.tao.apro.data.DataProvider;
import fr.lri.tao.apro.data.points.EuclideanSimilarityMeasure;
import fr.lri.tao.apro.data.points.Point;
import fr.lri.tao.apro.data.points.Points;
import fr.lri.tao.apro.data.points.SimilarityMeasure;
import fr.lri.tao.apro.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PointsProvider
implements DataProvider {
    private Points points;
    private SimilarityMeasure measure;
    private double[][] s;

    public PointsProvider(File file) throws IOException {
        this(file, (SimilarityMeasure)new EuclideanSimilarityMeasure());
    }

    public PointsProvider(File file, SimilarityMeasure measure) throws IOException {
        this.points = PointsProvider.load(file);
        this.measure = measure;
        this.s = measure.getMatrix(this.points);
    }

    public PointsProvider(Points points, SimilarityMeasure measure) {
        this.points = points;
        this.measure = measure;
        this.s = measure.getMatrix(this.points);
    }

    public PointsProvider(Points points) {
        this(points, (SimilarityMeasure)new EuclideanSimilarityMeasure());
    }

    private static Points load(File file) throws IOException {
        String line;
        Points points = new Points();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int nextId = 0;
        ArrayList<Double> vals = new ArrayList<Double>();
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, " ,;\t");
            vals.clear();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Double d = Double.valueOf(token);
                vals.add(d);
            }
            Point point = new Point((long)nextId++, vals);
            points.add(point);
        }
        reader.close();
        return points;
    }

    public Points getPoints() {
        return this.points;
    }

    public SimilarityMeasure getSimilarityMeasure() {
        return this.measure;
    }

    @Override
    public DoubleMatrix2D getMatrix() {
        return new DenseDoubleMatrix2D(this.s);
    }

    public double[][] getS() {
        return this.s;
    }

    @Override
    public int size() {
        return this.points.size();
    }

    @Override
    public void addNoise() {
        Utils.addNoise(this.s);
    }
}

