/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.hiap;

import fr.lri.tao.apro.data.points.Point;
import java.util.ArrayList;
import java.util.List;

class ExemplarStat {
    private Point exemplar;
    private double sum;
    private List<Double> sims = new ArrayList<Double>();

    ExemplarStat(Point exemplar) {
        this.exemplar = exemplar;
    }

    void add(Point point) {
        double d = this.exemplar.similarity(point);
        this.sum += d;
        this.sims.add(d);
    }

    double mean() {
        return this.sum / (double)this.sims.size();
    }

    double std() {
        if (this.sims.size() == 1) {
            return 0.0;
        }
        double mean = this.mean();
        double s = 0.0;
        for (Double d : this.sims) {
            double d1 = mean - d;
            s += d1 * d1;
        }
        s /= (double)(this.sims.size() - 1);
        s = Math.sqrt(s);
        return s;
    }

    int size() {
        return this.sims.size();
    }

    Point getExemplar() {
        return this.exemplar;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Exemplar ").append(this.exemplar).append(": ");
        sb.append(this.size()).append(" points\n");
        sb.append("mean=").append(this.mean());
        sb.append(", std=").append(this.std());
        return sb.toString();
    }
}

