/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.hiap;

import fr.lri.tao.apro.data.points.Point;
import fr.lri.tao.apro.data.points.Points;
import fr.lri.tao.apro.data.points.SimilarityMeasure;
import fr.lri.tao.apro.hiap.ExemplarStat;
import fr.lri.tao.apro.util.Percentile;
import java.util.HashMap;
import java.util.Map;

public class Exemplars {
    private Points points;
    private final Map<Point, ExemplarStat> exes = new HashMap<Point, ExemplarStat>();
    private final Map<Point, Point> exeMap = new HashMap<Point, Point>();

    public Exemplars(Points points) {
        this.points = points;
    }

    public Exemplars(Points points, int[] exemplars) {
        this(points);
        for (int i = 0; i < exemplars.length; ++i) {
            Point point = points.getByIndex(i);
            Point exemplar = points.getByIndex(exemplars[i]);
            this.add(point, exemplar);
        }
    }

    public int size() {
        return this.exes.size();
    }

    public Points getPoints() {
        return this.points;
    }

    public Point getByIndex(int i) {
        return (Point)this.getExemplars().get(i);
    }

    public void add(int pointIndex, int exemplarIndex) {
        this.add(this.points.getByIndex(pointIndex), this.points.getByIndex(exemplarIndex));
    }

    public synchronized void add(Point point, Point exemplar) {
        ExemplarStat stat = this.exes.get(exemplar);
        if (stat == null) {
            stat = new ExemplarStat(exemplar);
            this.exes.put(exemplar, stat);
        }
        stat.add(point);
        this.exeMap.put(point, exemplar);
    }

    public Point getExemplar(Point point) {
        return this.exeMap.get(point);
    }

    ExemplarStat getStat(Point exemplar) {
        return this.exes.get(exemplar);
    }

    public Points getExemplars() {
        Points points = new Points();
        for (Point point : this.exes.keySet()) {
            points.add(point);
        }
        return points;
    }

    public double[][] getWAPMatrix(SimilarityMeasure measure) {
        int n = this.size();
        double[][] s = new double[n][n];
        Percentile percentile = new Percentile();
        Points exemplars = this.getExemplars();
        for (int i = 0; i < n; ++i) {
            Point p1 = exemplars.getByIndex(i);
            int count = this.getStat(p1).size();
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                Point p2 = exemplars.getByIndex(j);
                double similarity = measure.similarity(p1, p2);
                s[i][j] = (double)count * similarity;
                percentile.add(similarity);
            }
        }
        double median = percentile.getMedian();
        for (int i = 0; i < n; ++i) {
            Point exemplar = exemplars.getByIndex(i);
            ExemplarStat stat = this.exes.get(exemplar);
            s[i][i] = median - (double)(stat.size() - 1) * stat.mean();
        }
        return s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Number of exemplars: ").append(this.exes.size()).append(" (out of ").append(this.points.size()).append(")");
        return sb.toString();
    }
}

