/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.hiap;

import fr.lri.tao.apro.ap.Apro;
import fr.lri.tao.apro.data.MatrixProvider;
import fr.lri.tao.apro.data.points.Point;
import fr.lri.tao.apro.data.points.Points;
import fr.lri.tao.apro.data.points.PointsProvider;
import fr.lri.tao.apro.hiap.DataParts;
import fr.lri.tao.apro.hiap.Exemplars;
import fr.lri.tao.apro.hiap.NodeWorker;
import fr.lri.tao.apro.hiap.PointsQueue;
import fr.lri.tao.apro.util.Logger;
import java.util.ArrayList;

public class HiAP {
    private PointsQueue queue;
    private final int workerIters;
    private final int wapIters;
    private final int threadsPerWorker;
    private final Integer[] nodes;
    private final int splits;
    private final Points allPoints;
    private Exemplars allExemplars;
    private Exemplars exemplars;
    private final PointsProvider provider;
    private double damp;

    public HiAP(PointsProvider provider, int splits, Integer[] numaNodes, int threadsPerWorker, int workerIters, int wapIters) {
        this.provider = provider;
        this.allPoints = provider.getPoints();
        this.splits = splits;
        this.nodes = numaNodes;
        this.threadsPerWorker = threadsPerWorker;
        this.workerIters = workerIters;
        this.wapIters = wapIters;
    }

    public HiAP(PointsProvider provider, int splits, int workers, int threadsPerWorker, int workerIters, int wapIters) {
        this.provider = provider;
        this.allPoints = provider.getPoints();
        this.splits = splits;
        this.nodes = new Integer[workers];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = null;
        }
        this.threadsPerWorker = threadsPerWorker;
        this.workerIters = workerIters;
        this.wapIters = wapIters;
    }

    int getThreadsPerWorker() {
        return this.threadsPerWorker;
    }

    int getWorkerIterationCount() {
        return this.workerIters;
    }

    PointsQueue getQueue() {
        return this.queue;
    }

    PointsProvider getProvider() {
        return this.provider;
    }

    Exemplars getAllExemplars() {
        return this.allExemplars;
    }

    public void setDamping(double dampingFactor) {
        this.damp = dampingFactor;
    }

    public double getDamping() {
        return this.damp;
    }

    public Points getPoints() {
        return this.allPoints;
    }

    public void run() throws InterruptedException {
        long start = System.currentTimeMillis();
        this.allPoints.shuffle();
        DataParts parts = new DataParts(this.allPoints, this.splits);
        this.queue = new PointsQueue(parts);
        this.allExemplars = new Exemplars(this.allPoints);
        ArrayList<NodeWorker> workers = new ArrayList<NodeWorker>();
        for (int i = 0; i < this.nodes.length; ++i) {
            Integer node = this.nodes[i];
            NodeWorker worker = new NodeWorker(this, node);
            worker.start();
            workers.add(worker);
        }
        for (NodeWorker worker : workers) {
            worker.join();
        }
        long lapTime = System.currentTimeMillis() - start;
        MatrixProvider wapProvider = new MatrixProvider(this.allExemplars.getWAPMatrix(this.provider.getSimilarityMeasure()));
        Apro wapro = new Apro(wapProvider, this.threadsPerWorker);
        wapro.setDamping(this.damp);
        wapro.run(this.wapIters);
        this.exemplars = new Exemplars(this.allPoints);
        int[] wex = wapro.getExemplars();
        for (int i = 0; i < wex.length; ++i) {
            int j = wex[i];
            Point point = this.allExemplars.getByIndex(i);
            Point exemplar = this.allExemplars.getByIndex(j);
            this.exemplars.add(point, exemplar);
        }
        long totalTime = System.currentTimeMillis() - start;
        long wapTime = totalTime - lapTime;
        Logger.info("[HiAP Done] From %d points to %d intermediate exemplars to %d final exemplars", this.allPoints.size(), this.allExemplars.size(), this.exemplars.size());
        Logger.info("[HiAP Time] %d nodes | %d splits | lap %d ms | wap %d ms | total %d ms", this.nodes.length, this.splits, lapTime, wapTime, totalTime);
    }

    public Point getExemplar(Point point) {
        Point e1 = this.allExemplars.getExemplar(point);
        return this.exemplars.getExemplar(e1);
    }

    public Point getExemplar(int id) {
        Point point = this.allPoints.getById(id);
        return this.getExemplar(point);
    }
}

