/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.hiap;

import fr.lri.tao.apro.data.points.PointsProvider;
import fr.lri.tao.apro.hiap.HiAP;
import fr.lri.tao.apro.util.Logger;
import fr.lri.tao.numa.NUMA;
import fr.lri.tao.numa.SysUtils;

public class HiAPBuilder {
    private int workers = 1;
    private boolean numaWorkers = false;
    private Integer[] workerNodes = null;
    private int splits = 2;
    private int threadsPerWorker = SysUtils.availableProcessors();
    private int workerIters = 100;
    private int wapIters = 100;

    public HiAPBuilder setWorkerIters(int workerIters) {
        this.workerIters = workerIters;
        return this;
    }

    public HiAPBuilder setWAPIters(int wapIters) {
        this.wapIters = wapIters;
        return this;
    }

    public HiAPBuilder setSplits(int splits) {
        this.splits = splits;
        return this;
    }

    public HiAPBuilder setWorkers(int workers) {
        this.workers = workers;
        return this;
    }

    public HiAPBuilder setWorkers(Integer[] workerNodes) {
        this.workerNodes = workerNodes;
        return this;
    }

    public HiAPBuilder setThreadsPerWorker(int threadsPerWorker) {
        this.threadsPerWorker = threadsPerWorker;
        return this;
    }

    public HiAPBuilder setNumaAuto() {
        if (NUMA.isAvailable()) {
            this.workers = NUMA.getNumNodes();
            this.numaWorkers = true;
            this.threadsPerWorker = NUMA.getCoresPerNode();
        } else {
            this.threadsPerWorker = SysUtils.availableProcessors();
        }
        return this;
    }

    public HiAP build(PointsProvider provider) {
        if (this.numaWorkers) {
            this.workerNodes = new Integer[this.workers];
            for (int i = 0; i < this.workerNodes.length; ++i) {
                this.workerNodes[i] = i;
            }
        } else if (this.workerNodes == null) {
            this.workerNodes = new Integer[this.workers];
            for (int i = 0; i < this.workers; ++i) {
                this.workerNodes[i] = null;
            }
        }
        Logger.info("Building HiAP with %d splits and %d workers", this.splits, this.workerNodes.length);
        return new HiAP(provider, this.splits, this.workerNodes, this.threadsPerWorker, this.workerIters, this.wapIters);
    }
}

