/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.hiap;

import fr.lri.tao.apro.ap.Apro;
import fr.lri.tao.apro.data.points.Points;
import fr.lri.tao.apro.data.points.PointsProvider;
import fr.lri.tao.apro.data.points.SimilarityMeasure;
import fr.lri.tao.apro.hiap.Exemplars;
import fr.lri.tao.apro.hiap.HiAP;
import fr.lri.tao.apro.hiap.PointsQueue;
import fr.lri.tao.apro.util.Logger;
import fr.lri.tao.numa.NUMA;

public class NodeWorker
extends Thread {
    private final HiAP hiap;
    private final Integer node;

    public NodeWorker(HiAP hiap, Integer numaNode) {
        this.hiap = hiap;
        this.node = numaNode;
    }

    public NodeWorker(HiAP hiap) {
        this(hiap, null);
    }

    @Override
    public void run() {
        if (this.node != null) {
            if (!NUMA.isAvailable()) {
                Logger.warn("NUMA library not available", new Object[0]);
            } else {
                NUMA.runOnNode(this.node);
            }
        }
        PointsQueue queue = this.hiap.getQueue();
        int coresPerNode = this.hiap.getThreadsPerWorker();
        int iters = this.hiap.getWorkerIterationCount();
        Points points = queue.get();
        while (points != null) {
            SimilarityMeasure measure = this.hiap.getProvider().getSimilarityMeasure();
            PointsProvider partProvider = new PointsProvider(points, measure);
            Apro apro = new Apro(partProvider, coresPerNode, false);
            apro.setDebug(false);
            apro.setDamping(this.hiap.getDamping());
            apro.run(iters);
            int[] exa = apro.getExemplars();
            Exemplars exes = this.hiap.getAllExemplars();
            for (int i = 0; i < exa.length; ++i) {
                int j = exa[i];
                exes.add(points.getByIndex(i), points.getByIndex(j));
            }
            points = queue.get();
        }
    }
}

