/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.apro.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Histogram<T> {
    Map<T, Integer> map = new HashMap<T, Integer>();

    public Histogram() {
    }

    public Histogram(Collection<T> collection) {
        this.add((T)collection);
    }

    public void add(Collection<T> collection) {
        for (T ranking : collection) {
            this.add(ranking);
        }
    }

    public Integer get(T key) {
        return this.map.get(key);
    }

    public void add(T key) {
        int i = this.count(key);
        this.map.put(key, i + 1);
    }

    public int count(T key) {
        Integer i = this.map.get(key);
        if (i == null) {
            i = 0;
        }
        return i;
    }

    public T getMostFrequent() {
        int max = 0;
        T key = null;
        for (T r : this.map.keySet()) {
            int c = this.map.get(r);
            if (c <= max) continue;
            max = c;
            key = r;
        }
        return key;
    }

    public void output(OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(this.map);
        oos.close();
    }

    public void input(InputStream is) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            this.map = (HashMap)ois.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ois.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (T t : this.map.keySet()) {
            sb.append(t).append(": ").append(this.map.get(t)).append("\n");
        }
        return sb.toString();
    }

    public int size() {
        return this.map.size();
    }
}

