/*
 * Decompiled with CFR 0.152.
 */
package fr.lri.tao.numa;

import fr.lri.tao.numa.CLibrary;
import fr.lri.tao.numa.LittleThread;
import fr.lri.tao.numa.NUMALibrary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class NUMA {
    public static boolean isAvailable() {
        try {
            return NUMALibrary.INSTANCE.numa_available() != -1;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static int getMaxNode() {
        return NUMALibrary.INSTANCE.numa_max_node();
    }

    public static int getNumNodes() {
        return NUMALibrary.INSTANCE.numa_num_task_nodes();
    }

    public static int getNumCores() {
        return NUMALibrary.INSTANCE.numa_num_task_cpus();
    }

    public static int getCoresPerNode() {
        return NUMA.getNumCores() / NUMA.getNumNodes();
    }

    public static int getNode(int cpu) {
        return NUMALibrary.INSTANCE.numa_node_of_cpu(cpu);
    }

    public static void allocOnNode(Integer node) {
        if (node != null) {
            NUMALibrary.INSTANCE.numa_set_preferred(node);
        } else {
            NUMA.localAlloc();
        }
    }

    public static void localAlloc() {
        if (!NUMA.isAvailable()) {
            return;
        }
        NUMALibrary.INSTANCE.numa_set_localalloc();
    }

    public static int runOnNode(int node) {
        int res = NUMALibrary.INSTANCE.numa_run_on_node(node);
        NUMALibrary.INSTANCE.numa_set_localalloc();
        return res;
    }

    public static int getCore() {
        return CLibrary.INSTANCE.sched_getcpu();
    }

    public static int getNode() {
        return NUMA.getNode(NUMA.getCore());
    }

    public static List<Integer> getCores(int node) {
        ArrayList<Integer> cores = new ArrayList<Integer>();
        NUMALibrary.Bitmask mask = NUMALibrary.INSTANCE.numa_allocate_cpumask();
        NUMALibrary.INSTANCE.numa_node_to_cpus(node, mask);
        int cc = NUMA.getNumCores();
        for (int cpu = 0; cpu < cc; ++cpu) {
            if (NUMALibrary.INSTANCE.numa_bitmask_isbitset(mask, cpu) <= 0) continue;
            cores.add(cpu);
        }
        return cores;
    }

    public static void main(String[] args) throws InterruptedException {
        int i;
        System.out.println("NUMA Available: " + NUMA.isAvailable());
        System.out.println("NUMA Nodes: " + NUMA.getNumNodes());
        System.out.println("NUMA Cores: " + NUMA.getNumCores());
        System.out.println("NUMA Node of core 44: " + NUMA.getNode(44));
        System.out.println("Running on node " + NUMA.getNode() + ", core " + NUMA.getCore());
        Random random = new Random();
        ArrayList<LittleThread> threads = new ArrayList<LittleThread>();
        for (i = 0; i < 100; ++i) {
            LittleThread t = new LittleThread(random.nextInt(NUMA.getNumNodes()));
            t.start();
            threads.add(t);
        }
        for (i = 0; i < 100; ++i) {
            ((Thread)threads.get(i)).join();
        }
        List<Integer> cores = NUMA.getCores(5);
        System.out.println(cores.size());
        System.out.println(Arrays.toString(cores.toArray()));
        System.out.println("Done.");
    }
}

